let addedPath;
let inputValue;


// Create a new list item when clicking on the "Add" button
// =====================================>>>
function addVideoSource(addBtn) {

    // Detect type of adding method and set video path to "inputValue" variable
    if (addBtn == 'byPath') {
        inputValue = document.getElementById("myInput").value;

    } else if (addBtn == 'fromServer') {
        let serverVideosSelector = document.getElementById("server-videos");
        let selectedItemIndex = document.getElementById("server-videos").selectedIndex;
        inputValue = serverVideosSelector[selectedItemIndex].innerText
    }

    //Create SRC item in list and DOM
    let li = document.createElement("li");
    if (inputValue === '') {
        alert("ابتدا مسیر تصویر را وارد کنید");
    } else {

        // document.getElementById('addMultiVideo').removeAttribute('disabled');

        //Create SRC item in list
        let addeItem = document.createElement("input");
        addeItem.setAttribute('value', inputValue);
        addeItem.setAttribute('readonly', 'true');
        li.appendChild(addeItem);

        document.getElementById("added-video-source").appendChild(li);


        // Add Sources To Dom
        let sourceNode = document.createElement('source');
        addedPath = document.getElementById('multiVideoLayer').children;
        sourceNode.setAttribute('src', inputValue);
        document.getElementById('multiVideoLayer').appendChild(sourceNode);


        creatingRemoveBadge(li)
    }

    mltVideo()
}
// <<<=====================================


//Removing Sources frome list (preview list)
// =====================================>>>
function creatingRemoveBadge(createdLi) {

    //Create close btn in list
    const span = document.createElement("SPAN");
    const txt = document.createTextNode("\u00D7");
    span.className = "close";
    span.appendChild(txt);
    createdLi.appendChild(span);

    // Click on a close button to remove the current list item
    var close = document.getElementsByClassName("close");
    var pathElement;


    
    for (i = 0; i < close.length; i++) {
        close[i].onclick = function () {
            pathElement = this.parentElement;
            for (n = 0; n < addedPath.length; n++) {

                // console.log(this.parentElement)
                if (pathElement.children[0].value == addedPath[n].src) {

                    addedPath[n].remove()
                    pathElement.remove()
                    console.log('matched addedPath')
                    break
                }

            }

            mltVideo()
            console.log('end addedpath', addedPath.length)
        }
    }
}
//  <<<<==================================



//add created preview to screen
// =====================================>>>
document.getElementById('addMultiVideo').addEventListener('click', function () {

    let videoToAdd = document.getElementById('multiVideoLayer')
    // let clonedVideoToAdd = videoToAdd.cloneNode(true)
    videoToAdd.classList = 'resize-drag video mltVideo';

    // Set entered width/height by user (or defaults)
    let mltVideoWidth = document.querySelector('.multi-video-width').value;
    let mltVideoHeight = document.querySelector('.multi-video-height').value;
    videoToAdd.style.width = `${mltVideoWidth}%`;
    videoToAdd.style.height = `${mltVideoHeight}%`;




    document.getElementById('screen').appendChild(videoToAdd)

    //Remove added sources from list
    // document.querySelector('#added-video-source').innerHTML = ''

    mltVideo()
    // videoGraber()
    document.getElementById('addVideoBtn').setAttribute('data-target', '')

    layersCounterHandler('+')

})
//  <<<<==================================



//multi video player
// =====================================>>>
function mltVideo() {
    const element = document.getElementById('multiVideoLayer');
    const videoCount = addedPath.length;
    let i = 0; // global


    function videoPlay(videoNum) {
        element.setAttribute("src", addedPath[videoNum].src);
        element.autoplay = true;
        element.load();
        element.play();
    }

    element.addEventListener('ended', myHandler, false);

    videoPlay(0); // play the video

    function myHandler() {
        i++;
        if (i == videoCount) {
            i = 0;
            videoPlay(i);
        } else {
            videoPlay(i);
        }
    }

}
//  <<<<==================================




// Reset multi video functionality
// =====================================>>> 
function multiVideoReset() {
    document.getElementById('multiVideoLayer').innerHTML = ""
    inputValue, element = undefined;
    document.getElementById("added-video-source").innerHTML = ""

    addedPath = undefined;
    console.log(document.getElementById('multiVideoLayer').children)
}
//  <<<<==================================


























// function printer(number) {

//     setInterval(function printMyNum() {
//         console.log(number)

//     }, 1000)
// }


// new printer(1)
// new printer(2)
// new printer(3)
// new printer(4)


