const addCalendarBtn = document.querySelector('#addCalendar');

const currentDate = new Date();
// const options = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' };
const Options = {
    fullCalendar: {
        weekday: 'long', year: 'numeric', month: 'numeric', day: 'numeric'
    },
    weekdayLess: {
        year: 'numeric', month: 'long', day: ''
    },
    dayLess: {
        weekday: '', year: 'numeric', month: 'long'
    },
    yearLess: {
        weekday: 'long', month: 'numeric', day: 'numeric'
    },
    mounthLess: {
        weekday: 'long', year: 'numeric', day: 'numeric'
    },
};



const calendarTypes = document.querySelectorAll('input[name="calendar-type"]');


//Set region, option and  add/remove calendar to/from preview box
function dateAdd(region, option, state) {

    // resolving Gregorian region value matter (most be undefined, not "undefined")
    if (region == 'undefined') {
        region = undefined;
    }


    if (state == true) {
        // Creating calendar - on type checkbox
        let calcedDate = currentDate.toLocaleDateString(region, option);
        let dateLayer = document.createElement('p');

        dateLayer.setAttribute('class', region);
        dateLayer.innerHTML = calcedDate;
        document.querySelector('.calendar-preview').appendChild(dateLayer);
        console.log(dateLayer);

    } else {
        //   remove- on type checkbox
        if (document.querySelector(`.${region}`)) {

            document.querySelector(`.${region}`).remove();
        }
    }

};
let selectedITypes;

// Check and disable add btn if any calendar not selected
for (let item of calendarTypes) {

    item.addEventListener('click', function () {
        // console.log(this.checked)
        selectedITypes = document.querySelectorAll('input[name="calendar-type"]:checked');
        if (selectedITypes.length) {
            addCalendarBtn.removeAttribute('disabled');
        } else {
            addCalendarBtn.setAttribute('disabled', true);
        }

        dateAdd(this.value, Options.fullCalendar, this.checked);
    })
}

// Set font size to the preview
document.querySelector('#customRange11').addEventListener('change', function () {
    const previewTags = document.querySelectorAll('.calendar-preview p');

    for (let calcPreviewTag of previewTags) {
        calcPreviewTag.style.fontSize = `${this.value}px`
    }
});

// Set font color to the preview
document.querySelector('.calendar-theme-selector').addEventListener('change', function () {
    const previewTags = document.querySelectorAll('.calendar-preview p');

    for (let calcPreviewTag of previewTags) {
        calcPreviewTag.style.color = this[this.selectedIndex].value;
    }
});


// Adding calendar to workspace
addCalendarBtn.addEventListener('click', function () {

    const calendarTag = document.createElement('div');
    const previewTags = document.querySelectorAll('.calendar-preview p');


    for (let calcPreviewTag of previewTags) {
        calendarTag.append(calcPreviewTag);
        // console.log(calcPreviewTag)

    }

    calendarTag.setAttribute('class', 'dragable date');
    calendarTag.setAttribute("id", `layer${layerCounter}-date`);
    document.querySelector('.screen').appendChild(calendarTag);
    layersCounterHandler('+');

});

// Do somthing on modal open/close

$('#modal-calendar').on('show.bs.modal', function () {

    if (document.querySelector('.screen div.date')) {

        document.querySelector('.calendar-preview').appendChild(document.querySelector('.screen div.date'))
  
      

    }
});


$('#modal-calendar').on('hidden.bs.modal', function () {
    
    // // console.log('modal close')
    
});



    
document.querySelector('.calendar-fromat-selector').addEventListener('change', function () {

    document.querySelector('.calendar-preview').innerHTML = '';
    for (let itemReg of selectedITypes) {
        dateAdd(itemReg.value, `option.${this[this.selectedIndex].value}`, true);
        console.log(itemReg.value)
    }



});



$(document).ready(function() {

    const $valueSpan = $('.valueSpan2');
    const $value = $('#customRange11');
    $valueSpan.html($value.val());
    $value.on('input change', () => {
  
      $valueSpan.html($value.val());
    });
  });