

function dragMoveListener(event) {
  var target = event.target
  // keep the dragged position in the data-x/data-y attributes
  var x = (parseFloat(target.getAttribute('data-x')) || 0) + event.dx
  var y = (parseFloat(target.getAttribute('data-y')) || 0) + event.dy

  // translate the element



  target.style.transform = 'translate(' + x + 'px, ' + y + 'px)'
  // console.log(target.style.transform)
  target.style.transform = 'translate(' + (x / screen.width) * 100 + 'vw,' + (y / screen.height) * 100 + 'vh)'

  // update the posiion attributes
  target.setAttribute('data-x', x)
  target.setAttribute('data-y', y)

}

// this function is used later in the resizing and gesture demos
window.dragMoveListener = dragMoveListener






// newwwwwwwwwwwwww
interact('.resize-drag')
  .resizable({
    // resize from all edges and corners
    edges: { left: true, right: true, bottom: true, top: true },

    listeners: {
      move(event) {
        var target = event.target;
        var x = (parseFloat(target.getAttribute('data-x')) || 0);
        var y = (parseFloat(target.getAttribute('data-y')) || 0);

        // update the element's style
        // target.style.width = event.rect.width + 'px'
        // target.style.height = event.rect.height + 'px'

        // update the element's width/height in % unit
        const screenWidth = document.querySelector(".screen").offsetWidth;
        const screenHeight = document.querySelector(".screen").offsetHeight;

        // const screenWidth = screen.width;
        // const screenHeight =screen.height
        // console.log('#################################')
        // console.log('target.style.width before', target.style.width)
        // console.log('(event.rect.width)', (event.rect.width))
        // console.log('(event.rect.width / screenWidth)', (event.rect.width / screenWidth))
        // console.log('(screenWidth)', (screenWidth))
        // console.log('(screenheight)',screenHeight )
        target.style.width = `${Math.round((event.rect.width / screenWidth) * 100)}%`;
        target.style.height = `${Math.round((event.rect.height / screenHeight) * 100)}%`;
        // console.log('target.style.width after', target.style.width)


        // translate when resizing from top or left edges
        x += event.deltaRect.left
        y += event.deltaRect.top


        target.setAttribute('data-x', x)
        target.setAttribute('data-y', y)

        // target.textContent = Math.round(event.rect.width) + '\u00D7' + Math.round(event.rect.height)
      }
    },
    modifiers: [
      // keep the edges inside the parent
      interact.modifiers.restrictEdges({
        outer: 'parent'
      }),

      // minimum size
      interact.modifiers.restrictSize({
        min: { width: 100, height: 50 }
      })
    ],

    inertia: true
  })
  .draggable({
    listeners: { move: window.dragMoveListener },
    inertia: false,
    modifiers: [
      interact.modifiers.restrictRect({
        restriction: 'parent',
        endOnly: true
      })
    ]
  })




  // just drag
  
// // newwwwwwwwwwwwww
interact('.dragable')
.draggable({


    listeners: {
      move(event) {
        var target = event.target;
        var x = (parseFloat(target.getAttribute('data-x')) || 0);
        var y = (parseFloat(target.getAttribute('data-y')) || 0);


        const screenWidth = document.querySelector(".screen").offsetWidth;
        const screenHeight = document.querySelector(".screen").offsetHeight;


        target.style.width = `${Math.round((event.rect.width / screenWidth) * 100)}%`;
        target.style.height = `${Math.round((event.rect.height / screenHeight) * 100)}%`;
        // console.log('target.style.width after', target.style.width)


        // translate when resizing from top or left edges
        x += event.deltaRect.left
        y += event.deltaRect.top


        target.setAttribute('data-x', x)
        target.setAttribute('data-y', y)

        // target.textContent = Math.round(event.rect.width) + '\u00D7' + Math.round(event.rect.height)
      }
    },
  listeners: { move: window.dragMoveListener },
  inertia: false,
  modifiers: [
    interact.modifiers.restrictRect({
      restriction: 'parent',
      endOnly: true
    })
  ]
})